/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.features;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.betterx.bclib.api.v3.levelgen.features.UserGrowableFeature;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.blocks.BlockWartSeed;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.world.features.NetherThreadDataStorage;
import org.betterx.betternether.world.features.NonOverlappingFeature;
import org.betterx.betternether.world.features.configs.NaturalTreeConfiguration;
import org.betterx.betternether.world.structures.StructureGeneratorThreadContext;

public class WartTreeFeature
extends NonOverlappingFeature<NaturalTreeConfiguration>
implements UserGrowableFeature<NaturalTreeConfiguration> {
    private static final BlockState WART_BLOCK = Blocks.f_50451_.m_49966_();
    private static final Direction[] HORIZONTAL = HorizontalDirectionalBlock.f_54117_.m_6908_().toArray(new Direction[0]);

    public WartTreeFeature() {
        super(NaturalTreeConfiguration.CODEC);
    }

    @Override
    protected boolean grow(ServerLevelAccessor world, BlockPos pos, RandomSource random, NaturalTreeConfiguration config, StructureGeneratorThreadContext context) {
        if (world.m_46859_(pos.m_6630_(1)) && world.m_46859_(pos.m_6630_(2))) {
            if (world.m_46859_(pos.m_6630_(2).m_122012_()) && world.m_46859_(pos.m_6630_(2).m_122019_()) && world.m_46859_(pos.m_6630_(2).m_122029_()) && world.m_46859_(pos.m_6630_(2).m_122024_()) && world.m_46859_(pos.m_6630_(3).m_122013_(2)) && world.m_46859_(pos.m_6630_(3).m_122020_(2)) && world.m_46859_(pos.m_6630_(3).m_122030_(2)) && world.m_46859_(pos.m_6630_(3).m_122025_(2))) {
                int py;
                int y;
                int pz;
                int z;
                int px;
                int x;
                int height = 5 + random.m_188503_(5);
                int h2 = height - 1;
                int width = (height >>> 2) + 1;
                int offset = width >>> 1;
                ArrayList<BlockPos> seedBlocks = new ArrayList<BlockPos>();
                for (x = 0; x < width; ++x) {
                    px = x + pos.m_123341_() - offset;
                    for (z = 0; z < width; ++z) {
                        pz = z + pos.m_123343_() - offset;
                        for (y = 0; y < height; ++y) {
                            py = y + pos.m_123342_();
                            context.POS.m_122178_(px, py, pz);
                            if (!this.isReplaceable(world.m_8055_((BlockPos)context.POS))) continue;
                            if (y == 0 && !this.isReplaceable(world.m_8055_(context.POS.m_7495_()))) {
                                BlocksHelper.setWithUpdate((LevelAccessor)world, (BlockPos)context.POS, NetherBlocks.MAT_WART.getRoot().m_49966_());
                            } else if (y < h2) {
                                BlocksHelper.setWithUpdate((LevelAccessor)world, (BlockPos)context.POS, NetherBlocks.MAT_WART.getLog().m_49966_());
                            } else {
                                BlocksHelper.setWithUpdate((LevelAccessor)world, (BlockPos)context.POS, WART_BLOCK);
                            }
                            if (random.m_188503_(8) != 0) continue;
                            Direction dir = HORIZONTAL[random.m_188503_(HORIZONTAL.length)];
                            seedBlocks.add(new BlockPos((Vec3i)context.POS).m_121945_(dir));
                        }
                    }
                }
                for (x = 0; x < width; ++x) {
                    px = x + pos.m_123341_() - offset;
                    block4: for (z = 0; z < width; ++z) {
                        pz = z + pos.m_123343_() - offset;
                        for (y = 1; y < height >> 1; ++y) {
                            py = pos.m_123342_() - y;
                            context.POS.m_122178_(px, py, pz);
                            if (!this.isReplaceable(world.m_8055_((BlockPos)context.POS))) continue;
                            if (this.isReplaceable(world.m_8055_(context.POS.m_7495_()))) {
                                BlocksHelper.setWithUpdate((LevelAccessor)world, (BlockPos)context.POS, NetherBlocks.MAT_WART.getLog().m_49966_());
                                continue;
                            }
                            BlocksHelper.setWithUpdate((LevelAccessor)world, (BlockPos)context.POS, NetherBlocks.MAT_WART.getRoot().m_49966_());
                            continue block4;
                        }
                    }
                }
                int headWidth = width + 2;
                ++offset;
                height = height - width - 1 + pos.m_123342_();
                for (int x2 = 0; x2 < headWidth; ++x2) {
                    int px2 = x2 + pos.m_123341_() - offset;
                    for (int z2 = 0; z2 < headWidth; ++z2) {
                        if (x2 == z2 || x2 == headWidth - z2 - 1) continue;
                        int pz2 = z2 + pos.m_123343_() - offset;
                        for (int y2 = 0; y2 < width; ++y2) {
                            int py2 = y2 + height;
                            context.POS.m_122178_(px2, py2, pz2);
                            if (!world.m_46859_((BlockPos)context.POS)) continue;
                            BlocksHelper.setWithUpdate((LevelAccessor)world, (BlockPos)context.POS, WART_BLOCK);
                            for (int i = 0; i < 4; ++i) {
                                seedBlocks.add(new BlockPos((Vec3i)context.POS).m_121945_(Direction.values()[random.m_188503_(6)]));
                            }
                        }
                    }
                }
                for (BlockPos pos2 : seedBlocks) {
                    this.PlaceRandomSeed((LevelAccessor)world, pos2);
                }
            }
            return true;
        }
        return false;
    }

    private void PlaceRandomSeed(LevelAccessor world, BlockPos pos) {
        BlockState seed = NetherBlocks.MAT_WART.getSeed().m_49966_();
        if (this.isReplaceable(world.m_8055_(pos))) {
            if (this.isWart(world.m_8055_(pos.m_7494_()))) {
                seed = (BlockState)seed.m_61124_((Property)BlockWartSeed.FACING, (Comparable)Direction.DOWN);
            } else if (this.isWart(world.m_8055_(pos.m_7495_()))) {
                seed = (BlockState)seed.m_61124_((Property)BlockWartSeed.FACING, (Comparable)Direction.UP);
            } else if (this.isWart(world.m_8055_(pos.m_122012_()))) {
                seed = (BlockState)seed.m_61124_((Property)BlockWartSeed.FACING, (Comparable)Direction.SOUTH);
            } else if (this.isWart(world.m_8055_(pos.m_122019_()))) {
                seed = (BlockState)seed.m_61124_((Property)BlockWartSeed.FACING, (Comparable)Direction.NORTH);
            } else if (this.isWart(world.m_8055_(pos.m_122029_()))) {
                seed = (BlockState)seed.m_61124_((Property)BlockWartSeed.FACING, (Comparable)Direction.WEST);
            } else if (this.isWart(world.m_8055_(pos.m_122024_()))) {
                seed = (BlockState)seed.m_61124_((Property)BlockWartSeed.FACING, (Comparable)Direction.EAST);
            }
            BlocksHelper.setWithUpdate(world, pos, seed);
        }
    }

    private boolean isReplaceable(BlockState state) {
        Block block = state.m_60734_();
        return state.m_247087_() || block == Blocks.f_50016_ || block == NetherBlocks.MAT_WART.getSeed() || block == NetherBlocks.BLACK_BUSH || block == NetherBlocks.SOUL_VEIN || block == NetherBlocks.SOUL_LILY || block == NetherBlocks.SOUL_LILY_SAPLING || block == Blocks.f_50200_;
    }

    private boolean isWart(BlockState state) {
        return state == WART_BLOCK || state.m_60734_() == NetherBlocks.MAT_WART.getLog();
    }

    @Override
    protected boolean isStructure(BlockState state) {
        return this.isWart(state);
    }

    @Override
    protected boolean isGround(BlockState state) {
        return BlocksHelper.isSoulSand(state);
    }

    public boolean grow(ServerLevelAccessor level, BlockPos pos, RandomSource random, NaturalTreeConfiguration configuration) {
        return this.grow(level, pos, random, new NaturalTreeConfiguration(false, configuration.distance), NetherThreadDataStorage.generatorForThread().context);
    }
}

